/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_properties;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class Properties {
    static String filename;
    public static Sorted prop;

    public static void load(String fn) {
        filename = fn;
        prop = new Sorted();
        try {
            prop.load(new FileInputStream(filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String fn(Class c, String att) {
        return c.getName() + "." + att;
    }

    private static String get(String an, String default_val) {
        String p = prop.getProperty(an);
        if (p == null) {
            p = default_val;
            Properties.set(an, p);
        }
        return p;
    }

    public static String get(Class c, String att, String default_val) {
        String an = Properties.fn(c, att);
        return Properties.get(an, default_val);
    }

    private static String set(String an, String val) {
        String p = prop.getProperty(an);
        if (p == null) {
            prop.setProperty(an, val);
            Properties.save();
        } else if (!p.equals(val)) {
            prop.setProperty(an, val);
            Properties.save();
        }
        return p;
    }

    public static String set(Class c, String att, String val) {
        String an = Properties.fn(c, att);
        return Properties.set(an, val);
    }

    public static void save() {
        try {
            prop.store(new FileOutputStream(filename), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        prop = null;
    }

    public static class Sorted
    extends java.util.Properties {
        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> mykeys = super.keys();
            Vector<Object> res = new Vector<Object>();
            while (mykeys.hasMoreElements()) {
                res.add(mykeys.nextElement());
            }
            Collections.sort(res);
            return res.elements();
        }
    }
}

