/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_logger;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.os10000.bldsys.lib_logwindow.Logwindow;
import net.os10000.bldsys.lib_properties.Properties;

public class Logger {
    int maxlines;
    long timer;
    long inter;
    long regular_delay;
    public boolean sep_window;
    public static Logger last_logger = null;
    public static PrintStream out = null;
    public static PrintStream err = null;
    static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private void init() {
        if (out == null) {
            out = System.out;
        }
        if (err == null) {
            err = System.err;
        }
        Class<?> cls = this.getClass();
        this.regular_delay = Long.parseLong(Properties.get(cls, "regular_delay", "10000"));
        this.maxlines = Integer.parseInt(Properties.get(cls, "maxlines", "1000"));
    }

    public Logger() {
        this.init();
        this.sep_window = false;
        last_logger = this;
    }

    public Logger(String window_title) {
        this.init();
        Class<?> cls = this.getClass();
        if (window_title == null) {
            window_title = "null";
        }
        if ((window_title = Properties.get(cls, "window_title", window_title)).compareTo("null") == 0) {
            this.sep_window = false;
        } else {
            this.sep_window = true;
            Logwindow.createAndShowGUI(window_title, this.maxlines);
        }
        last_logger = this;
    }

    public void msleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void regular_sleep() {
        this.msleep(this.regular_delay);
    }

    public static String now() {
        return df.format(new Date());
    }

    public void log(String x) {
        if (this.sep_window) {
            Logwindow.add(x);
        } else {
            out.print(x);
        }
    }

    public void log_same(String x) {
        if (this.sep_window) {
            Logwindow.add_same(x);
        } else {
            out.print("\r" + x);
        }
    }

    public void log_samets(String x) {
        this.log_same(Logger.now() + " " + x);
    }

    public void logln(String x) {
        this.log(x + "\n");
    }

    public void loglnts(String x) {
        this.logln(Logger.now() + " " + x);
    }

    public void loop_indefinitely() {
        while (true) {
            long secs = 3600L;
            try {
                Thread.sleep(1000L * secs);
            }
            catch (Exception exception) {
            }
        }
    }

    public void log_stacktrace(Exception e) {
        this.logln(Logger.make_stacktrace(e));
    }

    public static String make_stacktrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public void process_exception(Exception e, boolean verbose) {
        if (e instanceof SQLException) {
            SQLException sqle;
            if (verbose) {
                for (sqle = (SQLException)e; sqle != null; sqle = sqle.getNextException()) {
                    this.logln("\n---SQLException Caught---\n");
                    this.logln("SQLState:   " + sqle.getSQLState());
                    this.logln("Severity: " + sqle.getErrorCode());
                    this.logln("Message:  " + sqle.getMessage());
                    this.logln(Logger.make_stacktrace(sqle));
                }
            } else {
                this.logln("\n" + sqle.getSQLState() + ", " + sqle.getErrorCode());
            }
        } else {
            this.log_stacktrace(e);
        }
        this.logln("The processing has halted.  Please kill this process.");
        this.loop_indefinitely();
    }

    public void reset_timer(String l) {
        long current = new Date().getTime();
        long ela0 = current - this.inter;
        long ela1 = current - this.timer;
        this.log_samets("usecs elapsed at " + l + ": " + ela0 + ", total: " + ela1 + "   \n");
        this.inter = current;
        this.timer = current;
    }

    public void show_timer(String l) {
        long current = new Date().getTime();
        long ela = current - this.inter;
        this.log_samets("usecs elapsed at " + l + ": " + ela + "   \n");
        this.inter = current;
    }

    public void catch_std_streams(Process p) {
        new capture(this, p.getInputStream()).run();
        new capture(this, p.getErrorStream()).run();
    }

    public class capture
    implements Runnable {
        Logger l;
        InputStream s;

        public capture(Logger l, InputStream s) {
            this.l = l;
            this.s = s;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader input = new BufferedReader(new InputStreamReader(this.s));
                while ((line = input.readLine()) != null) {
                    this.l.logln(line);
                }
                input.close();
            }
            catch (Exception e) {
                this.l.log_stacktrace(e);
            }
        }
    }
}

