/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_dirtree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.os10000.bldsys.lib_dirtree.diff_entry;
import net.os10000.bldsys.mod_hash.Hash;

public class dir_entry
implements Comparable,
Serializable {
    public String name;
    public String hash;
    public dir_entry parent;
    public long last_modified;
    public long length;
    public SortedSet children;
    public boolean is_readonly;
    public boolean is_directory;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public int entry_count() {
        int sum = 1;
        for (dir_entry de : this.children) {
            sum += de.entry_count();
        }
        return sum;
    }

    public dir_entry() {
        System.out.println("no-args constructor of dir_entry");
    }

    public dir_entry(String name, dir_entry parent) {
        this.name = name;
        this.parent = parent;
    }

    public int compareTo(Object o) {
        dir_entry b = (dir_entry)o;
        return this.name.compareTo(b.name);
    }

    public String time_to_string(long t) {
        return sdf.format(new Date(t));
    }

    private String lpad(String x, String p, int l) {
        while (x.length() < l) {
            x = p + x;
        }
        return x;
    }

    public String get_full_path() {
        return (this.parent == null ? "" : this.parent.get_full_path() + "/") + this.name;
    }

    public String get_name() {
        return this.name;
    }

    public String get_hash() {
        return this.hash;
    }

    public String get_type() {
        return this.is_directory ? "d" : "f";
    }

    public String get_time() {
        return this.time_to_string(this.last_modified);
    }

    public String get_size() {
        return this.lpad(Long.toString(this.length), " ", 10);
    }

    public static String hash(File f) {
        String res = "xxx";
        try {
            Hash h = new Hash();
            FileInputStream i = new FileInputStream(f);
            byte[] buf = new byte[512];
            int bytes = ((InputStream)i).read(buf);
            while (bytes > 0) {
                h.update(buf, 0, bytes);
                bytes = ((InputStream)i).read(buf);
            }
            ((InputStream)i).close();
            res = h.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static dir_entry fetch_dir_entry(String entry_name, File f, dir_entry parent) {
        dir_entry res = new dir_entry(entry_name, parent);
        res.is_readonly = !f.canWrite();
        res.is_directory = f.isDirectory();
        res.last_modified = f.lastModified();
        res.length = f.length();
        res.children = new TreeSet();
        res.hash = dir_entry.hash(f);
        return res;
    }

    static dir_entry scan_tree(String fs_pfx, String entry_name, dir_entry parent, inc increaser) {
        increaser.increase();
        dir_entry res = null;
        String my_fs_pfx = fs_pfx + entry_name;
        File f = new File(my_fs_pfx);
        if (f.exists()) {
            res = dir_entry.fetch_dir_entry(entry_name, f, parent);
            if (res.is_directory) {
                my_fs_pfx = my_fs_pfx + File.separator;
                res.children = new TreeSet();
                for (File e : f.listFiles()) {
                    dir_entry de = dir_entry.scan_tree(my_fs_pfx, e.getName(), res, increaser);
                    if (de == null) continue;
                    res.children.add(de);
                }
            }
        } else {
            System.out.println("scan_tree: file '" + my_fs_pfx + "' does not exist.");
        }
        return res;
    }

    public static dir_entry scan_tree(String fs_pfx, String entry_name, inc increaser) {
        return dir_entry.scan_tree(fs_pfx, entry_name, null, increaser);
    }

    static void diff_dirs(List l, dir_entry a, dir_entry b) {
        dir_entry be;
        Iterator ai = a == null ? new NoNext() : a.children.iterator();
        Iterator bi = b == null ? new NoNext() : b.children.iterator();
        dir_entry ae = ai.hasNext() ? (dir_entry)ai.next() : null;
        dir_entry dir_entry2 = be = bi.hasNext() ? (dir_entry)bi.next() : null;
        while (ae != null && be != null) {
            int c = ae.name.compareTo(be.name);
            if (c < 0) {
                dir_entry.diff(l, ae, null);
                ae = ai.hasNext() ? (dir_entry)ai.next() : null;
                continue;
            }
            if (c > 0) {
                dir_entry.diff(l, null, be);
                be = bi.hasNext() ? (dir_entry)bi.next() : null;
                continue;
            }
            dir_entry.diff(l, ae, be);
            ae = ai.hasNext() ? (dir_entry)ai.next() : null;
            be = bi.hasNext() ? (dir_entry)bi.next() : null;
        }
        while (ae != null) {
            dir_entry.diff(l, ae, null);
            ae = ai.hasNext() ? (dir_entry)ai.next() : null;
        }
        while (be != null) {
            dir_entry.diff(l, null, be);
            be = bi.hasNext() ? (dir_entry)bi.next() : null;
        }
    }

    static boolean file_compare(dir_entry a, dir_entry b) {
        boolean same = true;
        same = a.last_modified == b.last_modified ? same : false;
        same = a.length == b.length ? same : false;
        same = a.is_readonly == b.is_readonly ? same : false;
        same = a.is_directory == b.is_directory ? same : false;
        return same;
    }

    static void diff_files(List l, dir_entry a, dir_entry b) {
        boolean same = dir_entry.file_compare(a, b);
        if (same) {
            l.add(new diff_entry(a));
        } else {
            l.add(new diff_entry(a, b));
        }
    }

    public static void diff(List l, dir_entry a, dir_entry b) {
        int ta = 0;
        if (a != null) {
            ta = a.is_directory ? 1 : 2;
        }
        int tb = 0;
        if (b != null) {
            int n = tb = b.is_directory ? 1 : 2;
        }
        if (ta != 0 || tb == 0) {
            // empty if block
        }
        if (ta == 0 && tb == 1) {
            l.add(new diff_entry(a, b));
            dir_entry.diff_dirs(l, a, b);
        }
        if (ta == 0 && tb == 2) {
            l.add(new diff_entry(a, b));
        }
        if (ta == 1 && tb == 0) {
            l.add(new diff_entry(a, b));
            dir_entry.diff_dirs(l, a, b);
        }
        if (ta == 1 && tb == 1) {
            dir_entry.diff_dirs(l, a, b);
        }
        if (ta == 1 && tb == 2) {
            l.add(new diff_entry(a, b));
            dir_entry.diff_dirs(l, a, null);
        }
        if (ta == 2 && tb == 0) {
            l.add(new diff_entry(a, b));
        }
        if (ta == 2 && tb == 1) {
            l.add(new diff_entry(a, b));
            dir_entry.diff_dirs(l, null, b);
        }
        if (ta == 2 && tb == 2) {
            dir_entry.diff_files(l, a, b);
        }
    }

    public long write_full_to_zip(String fs_pfx, String zf_pfx, String path, ZipOutputStream zos, Set s, inc increaser) throws IOException {
        long res = 0L;
        path = path + this.name;
        ZipEntry ze = new ZipEntry(zf_pfx + path);
        ze.setTime(this.last_modified);
        res += 300L;
        if (this.is_directory) {
            path = path + "/";
            for (dir_entry de : this.children) {
                res += de.write_full_to_zip(fs_pfx, zf_pfx, path, zos, s, increaser);
            }
        } else if (s.contains(path)) {
            zos.putNextEntry(ze);
            increaser.increase();
            byte[] buf = new byte[512];
            FileInputStream is = new FileInputStream(fs_pfx + path.replace('/', File.separatorChar));
            int bytes = ((InputStream)is).read(buf);
            while (bytes > 0) {
                res += (long)bytes;
                zos.write(buf, 0, bytes);
                bytes = ((InputStream)is).read(buf);
            }
            ((InputStream)is).close();
        }
        return res;
    }

    public dir_entry remove_items(String path, Set s, dir_entry p, inc increaser) {
        increaser.increase();
        dir_entry res = new dir_entry(this.name, p);
        res.hash = this.hash;
        res.last_modified = this.last_modified;
        res.length = this.length;
        res.children = new TreeSet();
        res.is_readonly = this.is_readonly;
        res.is_directory = this.is_directory;
        path = path + this.name;
        if (this.is_directory) {
            path = path + "/";
            for (dir_entry de : this.children) {
                dir_entry n = de.remove_items(path, s, res, increaser);
                if (n == null) continue;
                res.children.add(n);
            }
        } else if (s.contains(path)) {
            res = null;
        }
        return res;
    }

    public static interface inc {
        public void increase();
    }

    static class NoNext
    implements Iterator {
        NoNext() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

