/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_dirtree;

import net.os10000.bldsys.lib_dirtree.dir_entry;

public class diff_entry
implements Comparable {
    private String state;
    public dir_entry a;
    public dir_entry b;

    public diff_entry(dir_entry a, dir_entry b) {
        this.a = a;
        this.b = b;
        if (a == null && b == null) {
            try {
                throw new Exception("both null");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        this.state = a == null ? "added" : (b == null ? "deleted" : "modified");
    }

    public diff_entry(diff_entry x) {
        this.a = x.get_latest();
        this.b = x.get_latest();
        this.state = "nonexistent";
    }

    public diff_entry(dir_entry x) {
        this.a = x;
        this.b = x;
        this.state = "unchanged";
    }

    public boolean get_b_readonly() {
        return this.b.is_readonly;
    }

    public boolean get_b_isdir() {
        return this.b.is_directory;
    }

    public long get_b_lastmod() {
        return this.b.last_modified;
    }

    public dir_entry get_latest() {
        return this.b == null ? this.a : this.b;
    }

    public String get_latest_full_path() {
        return this.get_latest().get_full_path();
    }

    public String get_latest_type() {
        return this.get_latest().get_type();
    }

    String ex(String s) {
        return this.state.equals("nonexistent") ? "null" : s;
    }

    public String get_latest_name() {
        return this.ex(this.get_latest().get_name());
    }

    public String get_latest_time() {
        return this.ex(this.get_latest().get_time());
    }

    public String get_latest_size() {
        return this.ex(this.get_latest().get_size());
    }

    public String get_latest_hash() {
        return this.ex(this.get_latest().get_hash());
    }

    public String get_state() {
        return this.state;
    }

    public int compareTo(Object o) {
        diff_entry x = (diff_entry)o;
        return this.get_latest_full_path().compareTo(x.get_latest_full_path());
    }
}

