/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_dirtree;

import java.util.HashMap;
import java.util.Map;
import net.os10000.bldsys.lib_dirtree.Behaviour;
import net.os10000.bldsys.lib_dirtree.import_entry;
import net.os10000.bldsys.lib_properties.Properties;

public class RuleSet {
    private Class cls = this.getClass();
    public String default_rule;
    private String[] b_names = null;
    private Map behaviours = null;
    private static final String b_progress = "ignore if different and entrytype_dir;ignore if different and hash_same;ignore if different and remote_nonexistent;rename if different and remote_added/modified and local_added/modified and entrytype_file and hash_different/unknown;import if different and remote_added/modified and fresher_yes;import if different and local_nonexistent and remote_added/modified/unchanged;import if different and local_unchanged and remote_unchanged and fresher_yes;delete if different and local_unchanged and remote_deleted";
    private static final String b_local_hardmaster = "ignore if different";
    private static final String b_remote_hardmaster = "import if different and remote_added/modified;delete if different and remote_deleted;ignore if different and remote_nonexistent";
    private static final String b_local_softmaster = "ignore if different";
    private static final String b_remote_softmaster = "import if different and remote_added/modified";
    private static final String b_ignore = "ignore if different";
    private static final String b_import = "import if different";
    private static final String b_delete = "delete if different";
    private static final String b_export = "export if different";
    private static Map rsm = null;
    private static RuleSet rs = null;

    public RuleSet(String tpe) throws Exception {
        if (this.b_names == null) {
            this.behaviours = new HashMap();
            String bs = Properties.get(this.cls, "names." + tpe, "");
            if (bs.length() == 0) {
                bs = this.init_behaviours(tpe);
            }
            this.b_names = bs.split(" ");
            if (this.b_names == null) {
                throw new Exception("Ruleset.java/RuleSet(tpe): b_names=null!");
            }
            for (String b_name : this.b_names) {
                String b_text = Properties.get(this.cls, "behaviour." + tpe + "." + b_name, "");
                this.behaviours.put(b_name, Behaviour.from_string(b_name, b_text));
            }
        }
    }

    private String put_b(String tpe, String name, String b) {
        Properties.get(this.cls, "behaviour." + tpe + "." + name, b);
        return name;
    }

    private String init_behaviours(String tpe) throws Exception {
        String bs;
        if (tpe.compareTo("export") == 0) {
            bs = this.put_b(tpe, "export", b_export);
            bs = bs + " " + this.put_b(tpe, "ignore", "ignore if different");
            this.default_rule = "export";
        } else if (tpe.compareTo("import") == 0) {
            bs = this.put_b(tpe, "local_hardmaster", "ignore if different");
            bs = bs + " " + this.put_b(tpe, "remote_hardmaster", b_remote_hardmaster);
            bs = bs + " " + this.put_b(tpe, "local_softmaster", "ignore if different");
            bs = bs + " " + this.put_b(tpe, "remote_softmaster", b_remote_softmaster);
            bs = bs + " " + this.put_b(tpe, "progress", b_progress);
            bs = bs + " " + this.put_b(tpe, "ignore", "ignore if different");
            bs = bs + " " + this.put_b(tpe, "import", b_import);
            bs = bs + " " + this.put_b(tpe, "delete", b_delete);
            this.default_rule = "progress";
        } else {
            throw new Exception("Ruleset.java/init_behaviours: invalid tpe='" + tpe + "'");
        }
        return bs;
    }

    private Behaviour get_b(String n) throws Exception {
        return (Behaviour)this.behaviours.get(n);
    }

    public String[] names() throws Exception {
        return this.b_names;
    }

    public String evaluate(String n, import_entry ie) throws Exception {
        return this.get_b(n).evaluate(ie);
    }

    public static RuleSet get_rs(String tpe) throws Exception {
        RuleSet res;
        if (rsm == null) {
            rsm = new HashMap();
        }
        if ((res = (RuleSet)rsm.get(tpe)) == null) {
            res = new RuleSet(tpe);
            rsm.put(tpe, res);
        }
        return res;
    }
}

