/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_dirtree;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import net.os10000.bldsys.lib_dirtree.dir_entry;

public class DirTree
implements Serializable {
    public String tree_name;
    public String dir_name;
    dir_entry tree;

    private DirTree(String dir_name, String tree_name, dir_entry tree) {
        this.dir_name = dir_name;
        this.tree = tree;
        this.tree_name = tree_name;
    }

    public static DirTree load_from_file(String sync_file) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(sync_file));
        DirTree res = (DirTree)ois.readObject();
        ois.close();
        return res;
    }

    public static DirTree build_from_dir(String tree_name, String dir_name, dir_entry.inc increaser) throws FileNotFoundException, IOException {
        dir_entry tree = dir_entry.scan_tree(dir_name, "", increaser);
        if (tree == null) {
            throw new FileNotFoundException(dir_name);
        }
        DirTree res = new DirTree(dir_name, tree_name, tree);
        return res;
    }

    public static DirTree make_empty_tree(String tree_name, String dir_name) {
        return new DirTree(dir_name, tree_name, null);
    }

    public int entry_count() {
        return this.tree != null ? this.tree.entry_count() : 0;
    }

    public List diff(DirTree b) {
        LinkedList res = new LinkedList();
        dir_entry.diff(res, this.tree, b.tree);
        return res;
    }

    public void remove_noshow(Set x) {
    }

    public long write_to_zip(ZipOutputStream zos, Set s, dir_entry.inc increaser) throws IOException {
        String fs_pfx = this.dir_name;
        String zf_pfx = this.tree_name;
        return this.tree.write_full_to_zip(fs_pfx, zf_pfx, "", zos, s, increaser);
    }

    public void remove_items(Set s, dir_entry.inc increaser) {
        this.tree = this.tree.remove_items("", s, null, increaser);
    }
}

