/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.lib_dirtree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.os10000.bldsys.lib_dirtree.import_entry;
import net.os10000.bldsys.lib_properties.Properties;

public class Behaviour {
    private static final String[] dimension_entrytype_vals = new String[]{"dir", "file", "unknown"};
    private static final String[] dimension_hash_vals = new String[]{"unknown", "same", "different"};
    private static final String[] dimension_local_vals = new String[]{"added", "modified", "deleted", "unchanged", "nonexistent"};
    private static final String[] dimension_remote_vals = new String[]{"added", "modified", "deleted", "unchanged", "nonexistent"};
    private static long uncertainty_seconds = -1L;
    private static final String[] dimension_fresher_vals = new String[]{"yes", "maybe", "no"};
    private static Map dimensions = null;
    private String name;
    private Rule[] rules;

    private static void add_dim(Dimension d) {
        dimensions.put(d.name, d);
    }

    private static void init_dimensions() {
        dimensions = new HashMap();
        Behaviour.add_dim(new Dimension_Hash());
        Behaviour.add_dim(new Dimension_Local());
        Behaviour.add_dim(new Dimension_Remote());
        Behaviour.add_dim(new Dimension_Fresher());
        Behaviour.add_dim(new Dimension_EntryType());
    }

    private static Dimension make_dim(String cond) throws Exception {
        Dimension d;
        if (dimensions == null) {
            Behaviour.init_dimensions();
        }
        if ((d = (Dimension)dimensions.get(cond)) == null) {
            throw new Exception("Condition '" + cond + "' does not have a corresponding dimension.");
        }
        return d;
    }

    public String evaluate(import_entry ie) throws Exception {
        int j = this.rules.length;
        for (int i = 0; i < j; ++i) {
            String command = this.rules[i].match(ie);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private Behaviour(String name, Rule[] rules) throws Exception {
        this.name = name;
        this.rules = rules;
    }

    public static Behaviour from_string(String n, String b) throws Exception {
        Class<Behaviour> cls = Behaviour.class;
        uncertainty_seconds = Long.parseLong(Properties.get(cls, "uncertainty_seconds", "7200"));
        String[] rs = b.split(";");
        int i = 0;
        int j = rs.length;
        int k = 0;
        while (i < j) {
            if (rs[i++].length() <= 0) continue;
            ++k;
        }
        if (k == 0) {
            throw new Exception("you must have at least one rule for your Behaviour '" + n + "'.");
        }
        Rule[] my_rules = new Rule[k];
        j = 0;
        for (i = 0; i < k; ++i) {
            String r = rs[i];
            if (r.length() <= 0) continue;
            my_rules[j++] = Rule.make_Rule(r);
        }
        return new Behaviour(n, my_rules);
    }

    private static class Rule {
        String command;
        Dimension[] filters;
        Vector filter_values;
        static final String name_type = "[a-z]+";
        static final String d_name = "[a-z]+";
        static final String d_value_set = "[a-z]+(/[a-z]+)*";
        static final String dim = "[a-z]+_[a-z]+(/[a-z]+)*";
        static final String r_name = "[a-z]+";
        static final String r_pattern = "^([a-z]+) if different(( and [a-z]+_[a-z]+(/[a-z]+)*)*)$";

        private boolean verify_command(String cmd) {
            if (cmd.equals("export")) {
                return true;
            }
            if (cmd.equals("delete")) {
                return true;
            }
            if (cmd.equals("import")) {
                return true;
            }
            if (cmd.equals("rename")) {
                return true;
            }
            return cmd.equals("ignore");
        }

        private Set string_to_set(String all, String sep) {
            HashSet<String> res = new HashSet<String>();
            for (String s : all.split(sep)) {
                if (s.length() <= 0) continue;
                res.add(s);
            }
            return res;
        }

        private Rule(Matcher m) throws Exception {
            this.command = m.group(1);
            if (!this.verify_command(this.command)) {
                throw new Exception("A rule may not use the command '" + this.command + "'.");
            }
            String dims_together = m.group(2);
            if (dims_together != null) {
                String cond;
                String[] dims = dims_together.split(" ");
                int i = 0;
                int j = dims.length;
                int k = 0;
                while (i < j) {
                    if ((cond = dims[i++]).length() <= 2 || cond.equals("and")) continue;
                    ++k;
                }
                this.filters = new Dimension[k];
                this.filter_values = new Vector();
                k = 0;
                for (i = 0; i < j; ++i) {
                    if ((cond = dims[i++]).length() <= 2 || cond.equals("and")) continue;
                    String[] both = cond.split("_");
                    this.filters[k] = Behaviour.make_dim(both[0]);
                    this.filter_values.add(this.string_to_set(both[1], "/"));
                    ++k;
                }
            } else {
                this.filters = new Dimension[0];
                this.filter_values = new Vector();
            }
        }

        public static Rule make_Rule(String r) throws Exception {
            Pattern p = Pattern.compile(r_pattern);
            Matcher m = p.matcher(r);
            if (!m.matches()) {
                throw new Exception("the rule '" + r + "' does not match the pattern '" + r_pattern + "'.");
            }
            return new Rule(m);
        }

        public String match(import_entry ie) throws Exception {
            boolean res = true;
            int j = this.filters.length;
            for (int i = 0; res && i < j; ++i) {
                Dimension d = this.filters[i];
                Set fv = (Set)this.filter_values.get(i);
                String check_result = d.check(ie);
                boolean valid_result = false;
                int l = d.values.length;
                for (int k = 0; k < l; ++k) {
                    if (!check_result.equals(d.values[k])) continue;
                    valid_result = true;
                    k = l;
                }
                if (!valid_result) {
                    throw new Exception("Result '" + check_result + "' is not valid for Dimension '" + d.name + "'.");
                }
                res = fv.contains(check_result);
            }
            return res ? this.command : null;
        }
    }

    private static class Dimension_Fresher
    extends Dimension {
        public Dimension_Fresher() {
            super("fresher", dimension_fresher_vals);
        }

        @Override
        public String check(import_entry ie) {
            long dl = ie.local.get_latest().last_modified / 1000L;
            long dr = ie.remote.get_latest().last_modified / 1000L;
            String res = "maybe";
            if (dl > dr) {
                if (dl - dr > uncertainty_seconds) {
                    return "no";
                }
            } else if (dr - dl > uncertainty_seconds) {
                return "yes";
            }
            return res;
        }
    }

    private static class Dimension_Remote
    extends Dimension {
        public Dimension_Remote() {
            super("remote", dimension_remote_vals);
        }

        @Override
        public String check(import_entry ie) {
            return ie.remote.get_state();
        }
    }

    private static class Dimension_Local
    extends Dimension {
        public Dimension_Local() {
            super("local", dimension_local_vals);
        }

        @Override
        public String check(import_entry ie) {
            return ie.local.get_state();
        }
    }

    private static class Dimension_Hash
    extends Dimension {
        public Dimension_Hash() {
            super("hash", dimension_hash_vals);
        }

        @Override
        public String check(import_entry ie) {
            String res = null;
            String l = ie.get_latest_l_hash();
            String r = ie.get_latest_r_hash();
            res = l.equals("xxx") || r.equals("xxx") ? dimension_hash_vals[0] : (l.equals(r) ? dimension_hash_vals[1] : dimension_hash_vals[2]);
            return res;
        }
    }

    private static class Dimension_EntryType
    extends Dimension {
        public Dimension_EntryType() {
            super("entrytype", dimension_entrytype_vals);
        }

        @Override
        public String check(import_entry ie) {
            String t = ie.get_latest_type();
            String res = dimension_entrytype_vals[2];
            if (t.equals("d")) {
                res = dimension_entrytype_vals[0];
            } else if (t.equals("f")) {
                res = dimension_entrytype_vals[1];
            }
            return res;
        }
    }

    private static abstract class Dimension {
        public String name;
        public String[] values;

        protected Dimension(String n, String[] vs) {
            this.name = n;
            this.values = vs;
        }

        public abstract String check(import_entry var1);
    }
}

