/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.os10000.bldsys.app_dsync.Certificate;
import net.os10000.bldsys.app_dsync.FourTrees;
import net.os10000.bldsys.app_dsync.GUI;
import net.os10000.bldsys.app_dsync.Half;
import net.os10000.bldsys.app_dsync.Local_Tab;
import net.os10000.bldsys.app_dsync.ObjectStream;
import net.os10000.bldsys.app_dsync.OperationsDialog;
import net.os10000.bldsys.app_dsync.PM;
import net.os10000.bldsys.app_dsync.PM_logger;
import net.os10000.bldsys.app_dsync.RuleSets;
import net.os10000.bldsys.app_dsync.SyncFile;
import net.os10000.bldsys.lib_dirtree.DirTree;
import net.os10000.bldsys.lib_dirtree.import_entry;

public abstract class Tab
extends JPanel
implements ActionListener {
    boolean is_local;
    String tab_name;
    public int import_counter;
    String context_name;
    String tree_name;
    String tree_path;
    String import_file;
    String export_file;
    JButton b_remove;
    JButton b_save;
    protected String peer_info_header;
    protected Set peer_info_data;
    JLabel l_peer_info;
    JTextField t_import_file;
    JButton b_import_file_chooser;
    JButton b_perform_import;
    JTextField t_export_file;
    JButton b_export_file_chooser;
    JButton b_perform_export;
    private RuleSets rs_import;
    private RuleSets rs_export;
    public static final String name_syntax = "^[A-Za-z0-9@]+$";

    RuleSets rsi() throws Exception {
        try {
            if (this.rs_import == null) {
                this.rs_import = new RuleSets("import");
            }
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        return this.rs_import;
    }

    RuleSets rse() throws Exception {
        try {
            if (this.rs_export == null) {
                this.rs_export = new RuleSets("export");
            }
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        return this.rs_export;
    }

    public static boolean check_name(String name) {
        return name.matches(name_syntax);
    }

    protected DirTree make_tree(int estimate) throws IOException {
        String msg = "Scanning directory '" + this.tree_path + "'; expecting " + estimate + " entries.";
        PM_logger pm = new PM_logger(GUI.logger, msg, estimate + 1);
        ((PM)pm).set_fraction(1.0);
        DirTree res = DirTree.build_from_dir(this.tree_name, this.tree_path, pm);
        ((PM)pm).close();
        return res;
    }

    protected static Tab read(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Tab res = (Tab)ois.readObject();
        ois.close();
        return res;
    }

    public static void write(Tab t, OutputStream os) throws IOException {
        ObjectStream oos = new ObjectStream(os);
        oos.writeObject(t);
        oos.close();
    }

    public static void write(Tab t, String fn) throws IOException {
        FileOutputStream os = new FileOutputStream(fn);
        Tab.write(t, os);
        ((OutputStream)os).close();
    }

    protected Tab() {
        this.peer_info_data = new HashSet();
        this.set_peer_info();
    }

    protected Tab(boolean is_local, String tab_name, String context_name, String tree_name, String tree_path, String import_file, String export_file, String peer_info) throws Exception {
        this.import_counter = 0;
        this.is_local = is_local;
        this.tab_name = tab_name;
        this.context_name = context_name;
        this.tree_name = tree_name;
        this.tree_path = tree_path;
        this.import_file = import_file;
        this.export_file = export_file;
        this.peer_info_data = new HashSet();
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(600, 100));
        Half.wrap(Half.p_label("context name: " + context_name), this);
        Half.wrap(Half.p_label("tree name: " + tree_name), this);
        Half.wrap(Half.p_label("tree path: " + tree_path), this);
        Half.wrap(this.p_peer_info("peer info: "), this);
        this.add(new JSeparator(1));
        Half.wrap(this.p_import(import_file), this);
        Half.wrap(this.p_export(export_file), this);
        this.add(new JSeparator(1));
        Half.wrap(this.p_remove_save(), this);
        this.set_peer_info();
    }

    private JPanel p_peer_info(String peer_info_header) {
        this.peer_info_header = peer_info_header;
        JPanel p = new JPanel();
        this.l_peer_info = new JLabel(peer_info_header);
        p.add(this.l_peer_info);
        return p;
    }

    private JButton file_chooser() {
        URL ico_url = ClassLoader.getSystemResource("net/os10000/bldsys/app_dsync/data/folder.png");
        return new JButton(new ImageIcon(ico_url));
    }

    private JPanel p_import(String fn) {
        JPanel p = new JPanel();
        this.b_perform_import = new JButton("import");
        this.b_perform_import.addActionListener(this);
        p.add(this.b_perform_import);
        this.b_perform_import.setEnabled(!this.is_local);
        this.b_import_file_chooser = this.file_chooser();
        this.b_import_file_chooser.addActionListener(this);
        p.add(this.b_import_file_chooser);
        this.b_import_file_chooser.setEnabled(!this.is_local);
        this.t_import_file = new JTextField(fn, 20);
        p.add(this.t_import_file);
        this.t_import_file.setEnabled(!this.is_local);
        return p;
    }

    JPanel p_export(String fn) {
        JPanel p = new JPanel();
        this.b_perform_export = new JButton("export");
        this.b_perform_export.addActionListener(this);
        p.add(this.b_perform_export);
        this.b_export_file_chooser = this.file_chooser();
        this.b_export_file_chooser.addActionListener(this);
        p.add(this.b_export_file_chooser);
        this.t_export_file = new JTextField(fn, 20);
        p.add(this.t_export_file);
        return p;
    }

    JPanel p_remove_save() {
        JPanel p = new JPanel();
        this.b_remove = new JButton("remove this tab");
        this.b_remove.addActionListener(this);
        p.add(this.b_remove);
        this.b_save = new JButton("save this tab's settings");
        this.b_save.addActionListener(this);
        p.add(this.b_save);
        return p;
    }

    public void clear_peer() {
        this.peer_info_data.clear();
        this.set_peer_info();
    }

    public void remove_peer(String tab) {
        this.peer_info_data.remove(tab);
        this.set_peer_info();
    }

    public void add_peer(String tab) {
        this.peer_info_data.add(tab);
        this.set_peer_info();
    }

    private String set_to_string(Set s) {
        String res = "";
        String sep = "";
        for (String c : s) {
            res = res + sep + c;
            sep = " ";
        }
        return res;
    }

    public void set_peer_info() {
        if (this.is_local) {
            this.b_remove.setEnabled(this.peer_info_data.size() <= 0);
        }
        this.l_peer_info.setText(this.peer_info_header + this.set_to_string(this.peer_info_data));
    }

    protected static void extract_file(SyncFile sf, import_entry ie, String zfn, String lfn) throws Exception {
        if (!ie.are_same) {
            File f = new File(lfn);
            String p = f.getParent();
            if (p != null) {
                new File(p).mkdirs();
            }
            if (ie.remote.get_b_isdir()) {
                f.mkdir();
            } else {
                ZipEntry ze = sf.get_dzf().getEntry(zfn);
                if (ze == null) {
                    throw new Exception("file '" + zfn + "' is not contained in syncfile.");
                }
                InputStream is = sf.get_dzf().getInputStream(ze);
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buf = new byte[512];
                int bytes = is.read(buf, 0, buf.length);
                while (bytes > 0) {
                    fos.write(buf, 0, bytes);
                    bytes = is.read(buf, 0, buf.length);
                }
                fos.close();
                is.close();
                if (ie.remote.get_b_readonly()) {
                    f.setReadOnly();
                }
                f.setLastModified(ie.remote.get_b_lastmod());
            }
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public void internalPerformed(Object o) {
        if (o == this.b_import_file_chooser) {
            String fn = this.t_import_file.getText();
            fn = GUI.do_file(fn);
            this.t_import_file.setText(fn);
        } else if (o == this.b_export_file_chooser) {
            String fn = this.t_export_file.getText();
            fn = GUI.do_file(fn);
            this.t_export_file.setText(fn);
        } else if (o == this.b_remove) {
            int res = JOptionPane.showConfirmDialog(null, "Do you wish to remove this tab?", "Are you sure?", 0);
            if (res == 0) {
                if (this.is_local) {
                    GUI.local.tp_entries.remove(this);
                } else {
                    GUI.remote.tp_entries.remove(this);
                    for (Tab t : GUI.tabs.values()) {
                        try {
                            Local_Tab lt = (Local_Tab)t;
                            lt.remove_peer(this.tab_name);
                        }
                        catch (Exception e) {}
                    }
                }
                GUI.tabs.remove(this.tab_name);
                GUI.write_locations();
                new File(GUI.make_local_fn(this.tab_name + "_" + this.context_name + ".tab")).delete();
                boolean context_still_used = false;
                for (Tab t : GUI.tabs.values()) {
                    if (!this.context_name.equals(t.context_name)) continue;
                    context_still_used = true;
                }
                if (!context_still_used && !this.context_name.equals(GUI.local_context)) {
                    GUI.contexts.remove(this.context_name);
                    new File(GUI.make_local_fn(this.context_name + ".crt")).delete();
                }
                GUI.remote.set_add_button();
            }
        } else if (o == this.b_save) {
            try {
                Tab.write(this, GUI.make_local_fn(this.tab_name + "_" + this.context_name + ".tab"));
            }
            catch (Exception ex) {
                GUI.logger.log_stacktrace(ex);
            }
        }
    }

    protected static void performImport(List l, String pfx, SyncFile sf, Tab src, Tab dst) {
        String suffix = "-" + dst.tab_name + "-" + dst.import_counter + "-";
        PM_logger pm = new PM_logger(GUI.logger, "Import Operation", l.size());
        ((PM)pm).set_fraction(1.0);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ((PM)pm).increase();
            import_entry ie = (import_entry)i.next();
            String fn = ie.get_latest_full();
            String lfn = dst.tree_path + fn;
            String zfn = (pfx + fn).replace(File.separatorChar, '/');
            String op = ie.operation;
            try {
                if (op.equals("import")) {
                    GUI.logger.log_same("importing '" + lfn + "' ...\n");
                    Tab.extract_file(sf, ie, zfn, lfn);
                    continue;
                }
                if (op.equals("ignore")) continue;
                if (op.equals("delete")) {
                    GUI.logger.log_same("deleting '" + lfn + "' ...\n");
                    new File(lfn).delete();
                    continue;
                }
                if (op.equals("rename")) {
                    String ext;
                    String nfn;
                    GUI.logger.log_same("renaming '" + lfn + "' ...\n");
                    int eo = lfn.lastIndexOf(46);
                    if (eo > 0) {
                        nfn = lfn.substring(0, eo);
                        ext = lfn.substring(eo);
                    } else {
                        nfn = lfn;
                        ext = "";
                    }
                    String fn_l = nfn + suffix + "l" + ext;
                    String fn_r = nfn + suffix + "r" + ext;
                    new File(lfn).renameTo(new File(fn_l));
                    Tab.extract_file(sf, ie, zfn, lfn);
                    new File(lfn).renameTo(new File(fn_r));
                    continue;
                }
                throw new Exception("unknown operation '" + op + "' for import entry '" + fn + "'.");
            }
            catch (Exception e) {
                GUI.logger.log_stacktrace(e);
            }
        }
        GUI.logger.log_same("done.\n");
        GUI.logger.logln("saving state for next time.");
        try {
            String p = GUI.make_local_fn(src.tab_name + "_" + dst.context_name);
            ObjectStream os = new ObjectStream(new FileOutputStream(p + ".llpt"));
            os.writeObject(sf.get_last_remote_published_tree());
            os.close();
            os = new ObjectStream(new FileOutputStream(p + ".rlpt"));
            os.writeObject(sf.get_recommended_tree());
            os.close();
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        dst.internalPerformed(dst.b_save);
        GUI.logger.logln("done.");
    }

    public static void do_export(String fn, FourTrees ft, Tab src, Tab dst) {
        try {
            boolean is_import = false;
            SyncFile sf = new SyncFile(fn);
            String n_tab = src.tab_name;
            String n_tree = src.tree_name;
            Tab exp = dst == null ? src : dst;
            OperationsDialog.runDialog(is_import, ft, n_tree, sf, src, dst, exp.rse(), "Export of '" + n_tab + "'.");
        }
        catch (Exception ex) {
            GUI.logger.log_stacktrace(ex);
        }
    }

    public abstract void do_export(String var1, Tab var2, Tab var3);

    public void run_export(String fn, Tab src, Tab dst) {
        new Thread(new re(this, fn, src, dst)).start();
    }

    protected static void performExport(List l, String pfx, SyncFile sf, Tab src, Tab dst, FourTrees ft) {
        Certificate crt = (Certificate)GUI.contexts.get(GUI.local_context);
        PM_logger pm = new PM_logger(GUI.logger, "Building export/noshow lists ...", l.size());
        ((PM)pm).set_fraction(1.0);
        HashSet<String> noshow = new HashSet<String>();
        HashSet<String> export = new HashSet<String>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ((PM)pm).increase();
            import_entry ie = (import_entry)i.next();
            String fn = ie.get_latest_full().replace(File.separatorChar, '/');
            String op = ie.operation;
            if (op.equals("export")) {
                export.add(fn);
                continue;
            }
            if (!op.equals("noshow")) continue;
            noshow.add(fn);
        }
        ((PM)pm).close();
        GUI.logger.logln("items(export)=" + export.size());
        GUI.logger.logln("items(noshow)=" + noshow.size());
        pm = new PM_logger(GUI.logger, "Removing noshow-items ...", l.size());
        ((PM)pm).set_fraction(1.0);
        try {
            ft.lct.remove_items(noshow, pm);
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        ((PM)pm).close();
        pm = new PM_logger(GUI.logger, "Writing file.", export.size());
        ((PM)pm).set_fraction(1.0);
        try {
            sf.write(pm, 1.0, crt, GUI.private_key, ft.lct, ft.llpt, ft.rlpt, export);
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        ((PM)pm).close();
        GUI.logger.log_same("done.\n");
    }

    private class re
    implements Runnable {
        String fn;
        SyncFile sf;
        Tab me;
        Tab src;
        Tab dst;

        @Override
        public void run() {
            Tab.this.do_export(this.fn, this.src, this.dst);
        }

        public re(Tab me, String fn, Tab src, Tab dst) {
            this.me = me;
            this.fn = fn;
            this.src = src;
            this.dst = dst;
        }
    }
}

