/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.os10000.bldsys.app_dsync.Certificate;
import net.os10000.bldsys.app_dsync.ObjectStream;
import net.os10000.bldsys.app_dsync.PM;
import net.os10000.bldsys.app_dsync.PrvKey;
import net.os10000.bldsys.app_dsync.PrvKeyFrame;
import net.os10000.bldsys.app_dsync.SignatureOutputStream;
import net.os10000.bldsys.lib_dirtree.DirTree;

public class SyncFile {
    private String fn;
    private ZipFile czf;
    private ZipFile dzf;

    String get_fn() {
        return this.fn;
    }

    public SyncFile(String fn) {
        this.fn = fn;
        this.czf = null;
        this.dzf = null;
    }

    public ZipFile get_czf() throws IOException {
        if (this.czf == null) {
            this.czf = new ZipFile(this.fn);
        }
        return this.czf;
    }

    public ZipFile get_dzf() throws IOException {
        if (this.dzf == null) {
            this.get_czf();
            File tf = File.createTempFile("data", ".zip");
            tf.deleteOnExit();
            FileOutputStream os = new FileOutputStream(tf);
            ZipEntry ze = this.czf.getEntry("data.zip");
            InputStream is = this.czf.getInputStream(ze);
            byte[] buf = new byte[512];
            int bytes = is.read(buf, 0, buf.length);
            while (bytes > 0) {
                ((OutputStream)os).write(buf, 0, bytes);
                bytes = is.read(buf, 0, buf.length);
            }
            is.close();
            ((OutputStream)os).close();
            this.dzf = new ZipFile(tf);
        }
        return this.dzf;
    }

    public Certificate get_crt() throws IOException, ClassNotFoundException, SignatureException {
        this.get_czf();
        ZipEntry ze = this.czf.getEntry("source.crt");
        Certificate crt = Certificate.make_Certificate(this.czf.getInputStream(ze));
        return crt;
    }

    private DirTree get_tree(String name) throws IOException, ClassNotFoundException {
        this.get_dzf();
        ZipEntry ze = this.dzf.getEntry(name);
        ObjectInputStream ois = new ObjectInputStream(this.dzf.getInputStream(ze));
        DirTree tree = (DirTree)ois.readObject();
        ois.close();
        return tree;
    }

    public DirTree get_recommended_tree() throws IOException, ClassNotFoundException {
        return this.get_tree("recommended_tree.bin");
    }

    public DirTree get_last_local_published_tree() throws IOException, ClassNotFoundException {
        return this.get_tree("last_local_published_tree.bin");
    }

    public DirTree get_last_remote_published_tree() throws IOException, ClassNotFoundException {
        return this.get_tree("last_remote_published_tree.bin");
    }

    public String verify(Map contexts) throws IOException, ClassNotFoundException, SignatureException {
        String res = null;
        ZipFile zf = new ZipFile(this.fn);
        ZipEntry ze = zf.getEntry("source.crt");
        Certificate crt = Certificate.make_Certificate(zf.getInputStream(ze));
        Certificate c2 = (Certificate)contexts.get(crt.context_name);
        if (c2 != null && !c2.public_key.printable().equals(crt.public_key.printable())) {
            res = "crypto error: source.crt claims to be '" + c2.context_name + "', but it isn't.";
        }
        if (res == null) {
            ze = zf.getEntry("data.sig");
            byte[] sigbytes = (byte[])new ObjectInputStream(zf.getInputStream(ze)).readObject();
            ze = zf.getEntry("data.zip");
            boolean valid = crt.verify_stream(zf.getInputStream(ze), sigbytes);
            if (!valid) {
                res = "crypto error: data.sig does not sign data.zip with source.crt";
            }
        }
        zf.close();
        return res;
    }

    public void write(PM pm, double units, Certificate crt, PrvKey private_key, DirTree recommended_tree, DirTree last_local_published_tree, DirTree last_remote_published_tree, Set included_entries) throws IOException, InvalidKeyException {
        ZipOutputStream zs = new ZipOutputStream(new FileOutputStream(this.fn));
        zs.putNextEntry(new ZipEntry("source.crt"));
        crt.write_to_stream(zs);
        Signature signature = Certificate.make_sig();
        signature.initSign(PrvKeyFrame.k(private_key));
        zs.putNextEntry(new ZipEntry("data.zip"));
        File tf = File.createTempFile("data", ".zip");
        tf.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tf);
        ZipOutputStream dzs = new ZipOutputStream(fos);
        dzs.setLevel(9);
        pm.set_fraction(1.0 * units / 26.0);
        dzs.putNextEntry(new ZipEntry("recommended_tree.bin"));
        ObjectStream os = new ObjectStream(dzs);
        os.writeObject(recommended_tree);
        os.close();
        pm.increase();
        pm.set_fraction(1.0 * units / 26.0);
        dzs.putNextEntry(new ZipEntry("last_local_published_tree.bin"));
        os = new ObjectStream(dzs);
        os.writeObject(last_local_published_tree);
        os.close();
        pm.increase();
        pm.set_fraction(1.0 * units / 26.0);
        dzs.putNextEntry(new ZipEntry("last_remote_published_tree.bin"));
        os = new ObjectStream(dzs);
        os.writeObject(last_remote_published_tree);
        os.close();
        pm.increase();
        pm.set_fraction(1.0 * units / 26.0);
        pm.increase();
        float iec = included_entries.size();
        pm.set_fraction(10.0 / (double)iec * units / 26.0);
        long total_bytes = recommended_tree.write_to_zip(dzs, included_entries, pm);
        dzs.close();
        ((OutputStream)fos).close();
        pm.set_fraction(5120.0 / (double)total_bytes * units / 26.0);
        FileInputStream fis = new FileInputStream(tf);
        SignatureOutputStream sos = new SignatureOutputStream(signature, zs);
        byte[] buf = new byte[512];
        int bytes = ((InputStream)fis).read(buf, 0, buf.length);
        while (bytes > 0) {
            pm.increase();
            ((OutputStream)sos).write(buf, 0, bytes);
            bytes = ((InputStream)fis).read(buf, 0, buf.length);
        }
        ((OutputStream)sos).close();
        ((InputStream)fis).close();
        pm.set_fraction(1.0 * units / 26.0);
        zs.putNextEntry(new ZipEntry("data.sig"));
        try {
            ObjectStream os2 = new ObjectStream(zs);
            os2.writeObject(signature.sign());
            os2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pm.increase();
        zs.close();
    }
}

