/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableModel;
import net.os10000.bldsys.app_dsync.RegexRule;
import net.os10000.bldsys.lib_dirtree.RuleSet;

class RuleSets
implements Serializable {
    public String tpe;
    public String default_rule;
    public Vector l_regex_rules;
    public Vector h_regex_rules;
    public SortedMap directory_rules;
    public SortedMap file_rules;

    public RuleSets() {
    }

    public RuleSet get_rs() throws Exception {
        return RuleSet.get_rs(this.tpe);
    }

    public RuleSets(String tpe) throws Exception {
        this.tpe = tpe;
        this.default_rule = this.get_rs().default_rule;
        this.l_regex_rules = new Vector();
        this.directory_rules = new TreeMap();
        this.file_rules = new TreeMap();
        this.h_regex_rules = new Vector();
    }

    public static String[][] vec_to_mat(Vector v) {
        int j = v.size();
        String[][] res = new String[j][2];
        for (int i = 0; i < j; ++i) {
            RegexRule rr = (RegexRule)v.get(i);
            res[i][0] = rr.exp;
            res[i][1] = rr.rule;
        }
        return res;
    }

    public static void dtm_to_vec(DefaultTableModel dtm, Vector vec) {
        vec.clear();
        int j = dtm.getRowCount();
        for (int i = 0; i < j; ++i) {
            String exp = (String)dtm.getValueAt(i, 0);
            String rule = (String)dtm.getValueAt(i, 1);
            vec.add(new RegexRule(exp, rule));
        }
    }

    private String regex_get(String fn, Vector v) {
        for (RegexRule rr : v) {
            if (!Pattern.compile(rr.exp).matcher(fn).matches()) continue;
            return rr.rule;
        }
        return null;
    }

    public String l_regex_get(String fn) {
        return this.regex_get(fn, this.l_regex_rules);
    }

    public String h_regex_get(String fn) {
        return this.regex_get(fn, this.h_regex_rules);
    }
}

