/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.awt.event.ActionEvent;
import net.os10000.bldsys.app_dsync.FourTrees;
import net.os10000.bldsys.app_dsync.GUI;
import net.os10000.bldsys.app_dsync.Local_Tab;
import net.os10000.bldsys.app_dsync.OperationsDialog;
import net.os10000.bldsys.app_dsync.SyncFile;
import net.os10000.bldsys.app_dsync.Tab;
import net.os10000.bldsys.lib_dirtree.DirTree;

public class Remote_Tab
extends Tab {
    public String associated_peer;

    private Remote_Tab() {
    }

    protected Remote_Tab(String tab_name, String context_name, String tree_name, String tree_path, String import_file, String export_file, String peer_info) throws Exception {
        super(false, tab_name, context_name, tree_name, tree_path, import_file, export_file, peer_info);
        this.associated_peer = peer_info;
        this.add_peer(this.associated_peer);
    }

    public static Remote_Tab make(String tab_name, String context_name, String tree_name, String tree_path, String import_file, String export_file, String peer_info) throws Exception {
        Remote_Tab res = new Remote_Tab(tab_name, context_name, tree_name, tree_path, import_file, export_file, peer_info);
        return res;
    }

    public static void do_import(String fn, Tab src, Tab dst) {
        try {
            SyncFile sf = new SyncFile(fn);
            GUI.logger.logln("Verifying integrity of '" + fn + "' ...");
            String verify = sf.verify(GUI.contexts);
            if (verify != null) {
                throw new Exception(verify);
            }
            GUI.logger.logln("done.");
            FourTrees ft = new FourTrees();
            ft.llpt = sf.get_last_local_published_tree();
            ft.rct = sf.get_recommended_tree();
            ft.rlpt = sf.get_last_remote_published_tree();
            int estimate = ft.llpt.entry_count();
            int tmp = ft.rct.entry_count();
            estimate = tmp > estimate ? tmp : estimate;
            tmp = ft.rlpt.entry_count();
            estimate = tmp > estimate ? tmp : estimate;
            ft.lct = dst.make_tree(estimate);
            boolean is_import = true;
            String n_tab = src.tab_name;
            String n_tree = src.tree_name;
            OperationsDialog.runDialog(is_import, ft, n_tree, sf, src, dst, src.rsi(), "Import for Tab '" + n_tab + "'.");
        }
        catch (Exception ex) {
            GUI.logger.log_stacktrace(ex);
        }
    }

    public void run_import(String fn, Tab src, Tab dst) {
        new Thread(new ri(fn, src, dst)).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.b_perform_import) {
            Local_Tab dst = (Local_Tab)GUI.tabs.get(this.associated_peer);
            this.run_import(this.t_import_file.getText(), this, dst);
        } else if (o == this.b_perform_export) {
            Local_Tab src = (Local_Tab)GUI.tabs.get(this.associated_peer);
            this.run_export(this.t_export_file.getText(), src, this);
        } else {
            this.internalPerformed(o);
        }
    }

    @Override
    public void do_export(String fn, Tab src, Tab dst) {
        try {
            String p = GUI.make_local_fn(dst.tab_name + "_" + src.context_name);
            FourTrees ft = new FourTrees();
            try {
                ft.llpt = DirTree.load_from_file(p + ".llpt");
            }
            catch (Exception e) {
                String tree_name = src.tree_name;
                String dir_name = src.tree_path;
                ft.llpt = DirTree.make_empty_tree(tree_name, dir_name);
            }
            ft.rlpt = DirTree.load_from_file(p + ".rlpt");
            int e1 = ft.llpt.entry_count() + 1;
            int e2 = ft.rlpt.entry_count() + 1;
            ft.lct = src.make_tree(e1 > e2 ? e1 : e2);
            ft.rct = ft.rlpt;
            Remote_Tab.do_export(fn, ft, src, dst);
        }
        catch (Exception ex) {
            GUI.logger.log_stacktrace(ex);
        }
    }

    private class ri
    implements Runnable {
        String fn;
        SyncFile sf;
        Tab src;
        Tab dst;

        @Override
        public void run() {
            Remote_Tab.do_import(this.fn, this.src, this.dst);
        }

        public ri(String fn, Tab src, Tab dst) {
            this.fn = fn;
            this.src = src;
            this.dst = dst;
        }
    }
}

