/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import net.os10000.bldsys.app_dsync.Certificate;
import net.os10000.bldsys.app_dsync.GUI;
import net.os10000.bldsys.app_dsync.Half;
import net.os10000.bldsys.app_dsync.Local_Tab;
import net.os10000.bldsys.app_dsync.Remote_Tab;
import net.os10000.bldsys.app_dsync.SyncFile;
import net.os10000.bldsys.app_dsync.Tab;
import net.os10000.bldsys.lib_dirtree.DirTree;

public class Remote_Half
extends Half {
    private static final String pp = "net.os10000.bldsys.app_dsync.Remote.";
    public String path;

    public Remote_Half() {
        super("remote");
    }

    public void set_add_button() {
        boolean en = GUI.local.tp_entries.getTabCount() > 0;
        this.b_add.setEnabled(en);
    }

    @Override
    public void add() {
        String snc_fn;
        int tabs = GUI.local.tp_entries.getTabCount();
        Object[] possibleValues = new String[tabs];
        for (int i = 0; i < tabs; ++i) {
            possibleValues[i] = GUI.local.tp_entries.getTitleAt(i);
        }
        String local_partner = (String)JOptionPane.showInputDialog(null, "Choose the corresponding local partner", "Input", 1, null, possibleValues, possibleValues[0]);
        if (local_partner != null && (snc_fn = GUI.do_file(null)) != null) {
            Remote_Tab rt = null;
            try {
                SyncFile sf = new SyncFile(snc_fn);
                GUI.logger.logln("Verifying integrity of '" + snc_fn + "' ...");
                String verify = sf.verify(GUI.contexts);
                if (verify != null) {
                    throw new Exception(verify);
                }
                GUI.logger.logln("done.");
                Certificate crt = sf.get_crt();
                if (crt.context_name.equals(GUI.local_context)) {
                    throw new Exception("cannot add sync file from local context as remote tab.");
                }
                DirTree tree = sf.get_recommended_tree();
                String pfx = new File(snc_fn).getParentFile().getAbsolutePath();
                while (pfx.endsWith(File.separator)) {
                    pfx = pfx.substring(0, pfx.length() - 1);
                }
                pfx = pfx + File.separator;
                String local_tab = local_partner;
                String local_context = GUI.local_context;
                String short_remote = crt.context_name.replaceAll("^([^_]+)(_.*)*$", "$1");
                String remote_tab = this.make_name("tab", tree.tree_name + "@" + short_remote);
                if (remote_tab != null) {
                    String remote_context = crt.context_name;
                    String import_file = pfx + remote_context + "-" + local_context + ".snc";
                    String export_file = pfx + local_context + "-" + remote_context + ".snc";
                    rt = Remote_Tab.make(remote_tab, remote_context, tree.tree_name, tree.dir_name, import_file, export_file, local_tab);
                    Tab.write((Tab)rt, GUI.make_local_fn(remote_tab + "_" + remote_context + ".tab"));
                    this.tp_entries.add(remote_tab, rt);
                    GUI.contexts.put(remote_context, crt);
                    String remote_crt_fn = GUI.make_local_fn(remote_context + ".crt");
                    crt.write_to_stream(new FileOutputStream(remote_crt_fn));
                    GUI.tabs.put(remote_tab, rt);
                    GUI.write_locations();
                    GUI.frame.setVisible(false);
                    GUI.frame.pack();
                    GUI.frame.setVisible(true);
                    Local_Tab lt = (Local_Tab)GUI.tabs.get(local_tab);
                    lt.add_peer(remote_tab);
                    Remote_Tab src = rt;
                    Local_Tab dst = lt;
                    rt.run_import(snc_fn, src, dst);
                }
            }
            catch (Exception e) {
                GUI.logger.log_stacktrace(e);
            }
        }
    }
}

