/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

class OptionsTable
extends JScrollPane {
    public RowHeaderModel rhm;

    public OptionsTable(String[] headers, String[][] values) {
        DefaultTableModel dtm = new DefaultTableModel(values, headers);
        JTable table = new JTable(dtm);
        this.setViewportView(table);
        this.rhm = new RowHeaderModel(dtm);
        class RowHeader
        extends JList
        implements DropTargetListener,
        DragSourceListener,
        DragGestureListener {
            DragSource dragSource;
            DropTarget dropTarget;

            public RowHeader(RowHeaderModel rhm) {
                super(rhm);
                this.dragSource = null;
                this.dropTarget = null;
                this.dragSource = new DragSource();
                this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
                this.dropTarget = new DropTarget(this, this);
                this.dropTarget.setActive(true);
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    Transferable transferable = dtde.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        dtde.acceptDrop(2);
                        String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        int index = this.locationToIndex(dtde.getLocation());
                        RowHeaderModel rhm = (RowHeaderModel)this.getModel();
                        int old = rhm.find(s);
                        rhm.moveToIndex(old, index);
                        dtde.getDropTargetContext().dropComplete(true);
                    } else {
                        dtde.rejectDrop();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Exception" + e.getMessage());
                    dtde.rejectDrop();
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                    System.err.println("Exception" + e.getMessage());
                    dtde.rejectDrop();
                }
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                int index = this.locationToIndex(dge.getDragOrigin());
                String val = (String)((RowHeaderModel)this.getModel()).getElementAt(index);
                StringSelection text = new StringSelection(val);
                DragSource ds = dge.getDragSource();
                ds.startDrag(dge, DragSource.DefaultMoveDrop, text, this);
            }

            @Override
            public void dragExit(DragSourceEvent dsde) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }
        }
        RowHeader rowHeader = new RowHeader(this.rhm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(table.getRowHeight() + table.getRowMargin() + table.getIntercellSpacing().height - 2);
        class RowHeaderRenderer
        extends JLabel
        implements ListCellRenderer {
            RowHeaderRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value.toString());
                return this;
            }
        }
        rowHeader.setCellRenderer(new RowHeaderRenderer());
        rowHeader.setBackground(UIManager.getColor("TableHeader.background"));
        this.setRowHeaderView(rowHeader);
    }

    public void delete_row(String s) {
        int idx = this.rhm.find(s);
        this.rhm.delete_row(idx);
    }

    public void add_row(String[] row) {
        this.rhm.add_row(row);
    }

    public JLabel trashcan() {
        return new Trash(this);
    }

    class Trash
    extends JLabel
    implements DropTargetListener {
        private static final String fn = "net/os10000/bldsys/app_dsync/data/trashcan.png";
        DropTarget dropTarget;
        private OptionsTable ot;

        public Trash(OptionsTable ot) {
            super(new ImageIcon(ClassLoader.getSystemResource(fn)));
            this.dropTarget = null;
            this.ot = ot;
            this.dropTarget = new DropTarget(this, this);
            this.dropTarget.setActive(true);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable transferable = dtde.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(2);
                    String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.ot.delete_row(s);
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Exception" + e.getMessage());
                dtde.rejectDrop();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                System.err.println("Exception" + e.getMessage());
                dtde.rejectDrop();
            }
        }
    }

    public class RowHeaderModel
    extends AbstractListModel {
        Vector v;
        public DefaultTableModel dtm;

        public RowHeaderModel(DefaultTableModel dtm) {
            this.dtm = dtm;
            this.v = new Vector();
            int j = dtm.getRowCount();
            for (int i = 0; i < j; ++i) {
                this.v.add(Integer.toString(i));
            }
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.v.get(index);
        }

        public int find(String s) {
            int j = this.v.size();
            for (int i = 0; i < j; ++i) {
                if (((String)this.v.get(i)).compareTo(s) != 0) continue;
                return i;
            }
            return -1;
        }

        public void delete_row(int idx) {
            this.v.remove(idx);
            this.fireContentsChanged(this, idx, this.v.size() + 1);
            this.dtm.removeRow(idx);
        }

        public void add_row(String[] row) {
            int max = -1;
            int j = this.v.size();
            for (int i = 0; i < j; ++i) {
                int x = Integer.parseInt((String)this.v.get(i));
                if (x <= max) continue;
                max = x;
            }
            this.v.add(Integer.toString(max + 1));
            this.fireContentsChanged(this, 0, this.v.size() + 1);
            this.dtm.addRow(row);
        }

        public void moveToIndex(int src, int dst) {
            int upr;
            int lwr;
            int direction;
            if (src < dst) {
                direction = 1;
                lwr = src;
                upr = dst;
            } else {
                direction = -1;
                lwr = dst;
                upr = src;
            }
            Object tmp = this.v.get(src);
            for (int i = src; i != dst; i += direction) {
                this.v.set(i, this.v.get(i + direction));
            }
            this.v.set(dst, tmp);
            this.fireContentsChanged(this, lwr, upr);
            this.dtm.moveRow(src, src, dst);
        }
    }
}

