/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import net.os10000.bldsys.app_dsync.FourTrees;
import net.os10000.bldsys.app_dsync.GUI;
import net.os10000.bldsys.app_dsync.RegexDialog;
import net.os10000.bldsys.app_dsync.RuleSets;
import net.os10000.bldsys.app_dsync.SyncFile;
import net.os10000.bldsys.app_dsync.Tab;
import net.os10000.bldsys.lib_dirtree.diff_entry;
import net.os10000.bldsys.lib_dirtree.dir_entry;
import net.os10000.bldsys.lib_dirtree.import_entry;
import net.os10000.bldsys.mod_diff.Server;

class OperationsTableModel
extends AbstractTableModel
implements TableColumnModelListener,
ListSelectionListener,
ActionListener {
    Map dialog_items;
    String pfx;
    Tab src;
    Tab dst;
    Tab active_tab;
    RuleSets rulesets;
    List l;
    FourTrees ft;
    private SyncFile sf;
    private JFrame jf;
    private JTable jt;
    private boolean operation_changed;
    private boolean is_import;
    public static int[] new_order = null;
    public static int[] sort_order = null;
    public static String[] columnNames = new String[]{"operation", "op_src", "full", "type", "file", "ext", "time", "size", "state"};
    private static row_sorter sorter = null;

    public OperationsTableModel(boolean is_import, FourTrees ft, String pfx, SyncFile sf, Tab src, Tab dst, Map dialog_items, JFrame jf, RuleSets rulesets) {
        this.is_import = is_import;
        this.ft = ft;
        this.l = ft.export_decisions();
        this.jf = jf;
        this.src = src;
        this.dst = dst;
        this.sf = sf;
        this.pfx = pfx;
        this.rulesets = rulesets;
        this.operation_changed = true;
        this.dialog_items = dialog_items;
        new_order = new int[columnNames.length];
        sort_order = new int[columnNames.length];
        this.active_tab = is_import ? dst : src;
        int j = columnNames.length;
        for (int i = 0; i < j; ++i) {
            OperationsTableModel.sort_order[i] = i;
        }
    }

    public void set_jt(JTable jt) {
        this.jt = jt;
        this.set_label("Default", this.rulesets.default_rule);
        this.recompute_operations();
        this.update_buttons();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.l.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        String res = null;
        import_entry ie = (import_entry)this.l.get(row);
        switch (col) {
            case 0: {
                res = ie.get_operation();
                break;
            }
            case 1: {
                res = ie.get_operation_src();
                break;
            }
            case 2: {
                res = ie.get_latest_full();
                break;
            }
            case 3: {
                res = ie.get_latest_type();
                break;
            }
            case 4: {
                res = ie.get_latest_file();
                break;
            }
            case 5: {
                res = ie.get_latest_extn();
                break;
            }
            case 6: {
                res = ie.get_latest_time();
                break;
            }
            case 7: {
                res = ie.get_latest_size();
                break;
            }
            case 8: {
                res = ie.get_state();
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 5;
    }

    private void sort_table() {
        if (sorter == null) {
            sorter = new row_sorter();
        }
        Collections.sort(this.l, sorter);
        this.fireTableDataChanged();
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        if (this.jt.getColumnCount() == columnNames.length) {
            int i;
            int j = this.jt.getColumnCount();
            for (i = 0; i < j; ++i) {
                OperationsTableModel.new_order[i] = this.jt.convertColumnIndexToModel(i);
            }
            if (!Arrays.equals(new_order, sort_order)) {
                j = this.jt.getColumnCount();
                for (i = 0; i < j; ++i) {
                    OperationsTableModel.sort_order[i] = new_order[i];
                }
                this.sort_table();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.update_buttons();
    }

    private String get_new_rule(String r) {
        String res = r;
        try {
            Component parentComponent = null;
            String message = "Please choose the desired rule";
            String title = "Rule selection";
            int messageType = 3;
            Icon icon = null;
            Object[] selectionValues = this.rulesets.get_rs().names();
            String initialSelectionValue = r;
            String x = (String)JOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue);
            if (x != null) {
                res = x;
            }
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
        return res;
    }

    private void clear_operations() {
        for (import_entry ie : this.l) {
            if (!ie.operation_src.endsWith("rule")) continue;
            ie.operation = "";
            ie.operation_src = "";
        }
    }

    private void recompute_h_regex_operations() throws Exception {
        for (import_entry ie : this.l) {
            String op;
            String f;
            String rn;
            if (ie.operation_src.length() != 0 || (rn = this.rulesets.h_regex_get(f = ie.get_latest_full())) == null || (op = this.rulesets.get_rs().evaluate(rn, ie)) == null) continue;
            ie.operation = op;
            ie.operation_src = "H-RegEx";
            this.operation_changed = true;
        }
    }

    private void recompute_file_operations() throws Exception {
        for (import_entry ie : this.l) {
            String op;
            String f;
            String rn;
            if (ie.operation_src.length() != 0 || (rn = (String)this.rulesets.file_rules.get(f = ie.get_latest_full())) == null || (op = this.rulesets.get_rs().evaluate(rn, ie)) == null) continue;
            ie.operation = op;
            ie.operation_src = "File rule";
            this.operation_changed = true;
        }
    }

    private void recompute_directory_operations() throws Exception {
        Object[] ka = this.rulesets.directory_rules.keySet().toArray();
        Arrays.sort(ka);
        for (int i = ka.length - 1; i > -1; --i) {
            String r = (String)ka[i];
            String rn = (String)this.rulesets.directory_rules.get(r);
            for (import_entry ie : this.l) {
                String op;
                String f;
                if (ie.operation_src.length() != 0 || !(f = ie.get_latest_full()).startsWith(r) || (op = this.rulesets.get_rs().evaluate(rn, ie)) == null) continue;
                ie.operation = op;
                ie.operation_src = "Directory rule";
                this.operation_changed = true;
            }
        }
    }

    private void recompute_l_regex_operations() throws Exception {
        for (import_entry ie : this.l) {
            String op;
            String f;
            String rn;
            if (ie.operation_src.length() != 0 || (rn = this.rulesets.l_regex_get(f = ie.get_latest_full())) == null || (op = this.rulesets.get_rs().evaluate(rn, ie)) == null) continue;
            ie.operation = op;
            ie.operation_src = "L-RegEx";
            this.operation_changed = true;
        }
    }

    private void recompute_default_operations() throws Exception {
        for (import_entry ie : this.l) {
            String op;
            if (!ie.operation_src.equals("") || (op = this.rulesets.get_rs().evaluate(this.rulesets.default_rule, ie)) == null) continue;
            ie.operation = op;
            ie.operation_src = "Default rule";
            this.operation_changed = true;
        }
    }

    private void recompute_operations() {
        try {
            this.clear_operations();
            this.recompute_h_regex_operations();
            this.recompute_file_operations();
            this.recompute_directory_operations();
            this.recompute_l_regex_operations();
            this.recompute_default_operations();
            if (this.operation_changed) {
                this.sort_table();
            }
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
    }

    private void set_label(String l, String r) {
        JLabel jl = (JLabel)this.dialog_items.get("txt-" + l);
        jl.setText(r);
    }

    private void direct_button(String b) {
        int[] rows = this.jt.getSelectedRows();
        int j = rows.length;
        for (int i = 0; i < j; ++i) {
            import_entry ie = (import_entry)this.l.get(rows[i]);
            ie.operation = b;
            ie.operation_src = "user";
            this.operation_changed = true;
        }
        this.recompute_operations();
    }

    private String make_tempfile(String pfx, InputStream i) throws IOException {
        File f = File.createTempFile(pfx, "tmp");
        f.deleteOnExit();
        FileOutputStream o = new FileOutputStream(f);
        int b = i.read();
        while (b > -1) {
            if (b != 13) {
                ((OutputStream)o).write(b);
            }
            b = i.read();
        }
        ((OutputStream)o).close();
        i.close();
        return f.getAbsolutePath();
    }

    private String make_tempfile_f(String fn) throws IOException {
        return this.make_tempfile("local-", new FileInputStream(fn));
    }

    private String make_tempfile_z(String zfn) throws IOException {
        return this.make_tempfile("remote-", this.sf.get_dzf().getInputStream(this.sf.get_dzf().getEntry(zfn)));
    }

    private JPanel make_details_upper(import_entry ie) {
        JPanel res = new JPanel();
        res.setLayout(new BoxLayout(res, 1));
        String f = ie.get_latest_full();
        res.add(new JLabel("File: " + f));
        String fr = (String)this.rulesets.file_rules.get(f);
        if (fr == null) {
            fr = "";
        }
        res.add(new JLabel("File Rule: " + fr));
        String dr = (String)this.rulesets.directory_rules.get(f);
        if (dr == null) {
            dr = "";
        }
        res.add(new JLabel("Directory Rule: " + dr));
        res.add(new JLabel("Operation: " + ie.operation));
        res.add(new JLabel("Operation Source: " + ie.operation_src));
        return res;
    }

    private static String ft(dir_entry de, int f) {
        String res = "null";
        if (de != null) {
            switch (f) {
                case 0: {
                    res = Boolean.toString(de.is_readonly);
                    break;
                }
                case 1: {
                    res = Boolean.toString(de.is_directory);
                    break;
                }
                case 2: {
                    res = Long.toString(de.last_modified);
                    break;
                }
                case 3: {
                    res = Long.toString(de.length);
                    break;
                }
                default: {
                    res = de.hash;
                }
            }
        }
        return res;
    }

    private static String fts(diff_entry de, int f) {
        String rb;
        String ra = OperationsTableModel.ft(de.a, f);
        return ra.equals(rb = OperationsTableModel.ft(de.b, f)) ? ra : ra + " " + rb;
    }

    private JPanel make_details(String lr, diff_entry de) {
        JPanel res = new JPanel();
        res.setLayout(new BoxLayout(res, 1));
        res.add(new JLabel("side: " + lr));
        res.add(new JLabel("state: " + de.get_state()));
        res.add(new JLabel("is_readonly: " + OperationsTableModel.fts(de, 0)));
        res.add(new JLabel("is_directory: " + OperationsTableModel.fts(de, 1)));
        res.add(new JLabel("last_modified: " + OperationsTableModel.fts(de, 2)));
        res.add(new JLabel("file_size: " + OperationsTableModel.fts(de, 3)));
        res.add(new JLabel("hash: " + OperationsTableModel.fts(de, 4)));
        return res;
    }

    private JPanel make_details_lower(import_entry ie) {
        JPanel res = new JPanel();
        res.setLayout(new BoxLayout(res, 0));
        res.add(this.make_details("remote", ie.remote));
        res.add(new JSeparator(1));
        res.add(this.make_details("local", ie.local));
        return res;
    }

    public void rules_changed() {
        System.out.println("rules_changed()");
        this.recompute_operations();
        this.active_tab.internalPerformed(this.active_tab.b_save);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        String name = (String)this.dialog_items.get(s);
        if (name.equals("change-Default")) {
            String nr = this.get_new_rule(this.rulesets.default_rule);
            if (!nr.equals(this.rulesets.default_rule)) {
                this.rulesets.default_rule = nr;
                this.set_label("Default", nr);
                this.rules_changed();
            }
        } else if (name.equals("list/edit-high-prio-regex")) {
            try {
                RegexDialog.runDialog("High", this.active_tab, this.rulesets.get_rs().names(), this.rulesets.h_regex_rules, this);
            }
            catch (Exception ex) {
                GUI.logger.log_stacktrace(ex);
            }
        } else if (name.equals("list/edit-low-prio-regex")) {
            try {
                RegexDialog.runDialog("Low", this.active_tab, this.rulesets.get_rs().names(), this.rulesets.l_regex_rules, this);
            }
            catch (Exception ex) {
                GUI.logger.log_stacktrace(ex);
            }
        } else if (name.equals("change-Directory")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            String f = ie.get_latest_full();
            String rn = (String)this.rulesets.directory_rules.get(f);
            String nr = this.get_new_rule(rn);
            if (!nr.equals(rn)) {
                this.rulesets.directory_rules.put(f, nr);
                this.set_label("Directory", nr);
                this.rules_changed();
            }
        } else if (name.equals("remove-Directory")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            String f = ie.get_latest_full();
            this.rulesets.directory_rules.remove(f);
            this.set_label("Directory", "--------------------");
            this.rules_changed();
        } else if (name.equals("change-File")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            String f = ie.get_latest_full();
            String rn = (String)this.rulesets.file_rules.get(f);
            String nr = this.get_new_rule(rn);
            if (!nr.equals(rn)) {
                this.rulesets.file_rules.put(f, nr);
                this.set_label("File", nr);
                this.rules_changed();
            }
        } else if (name.equals("remove-File")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            String f = ie.get_latest_full();
            this.rulesets.file_rules.remove(f);
            this.set_label("File", "--------------------");
            this.rules_changed();
        } else if (name.equals("ignore")) {
            this.direct_button(name);
        } else if (name.equals("import")) {
            this.direct_button(name);
        } else if (name.equals("delete")) {
            this.direct_button(name);
        } else if (name.equals("rename")) {
            this.direct_button(name);
        } else if (name.equals("ok")) {
            this.jf.setVisible(false);
            if (this.is_import) {
                Tab.performImport(this.l, this.pfx, this.sf, this.src, this.dst);
            } else {
                Tab.performExport(this.l, this.pfx, this.sf, this.src, this.dst, this.ft);
            }
            this.jf.dispose();
        } else if (name.equals("details")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            try {
                JPanel tp = new JPanel();
                tp.setOpaque(true);
                tp.setLayout(new BoxLayout(tp, 1));
                tp.add(this.make_details_upper(ie));
                tp.add(new JSeparator(0));
                tp.add(this.make_details_lower(ie));
                JFrame frame = new JFrame("Details for '" + ie.get_latest_full() + "'.");
                frame.setDefaultCloseOperation(2);
                frame.setContentPane(tp);
                frame.pack();
                frame.setVisible(true);
            }
            catch (Exception ex) {
                GUI.logger.log_stacktrace(ex);
            }
        } else if (name.equals("file diff")) {
            int row = this.jt.getSelectedRow();
            import_entry ie = (import_entry)this.l.get(row);
            String fn = ie.get_latest_full();
            try {
                Tab fs_tab = this.is_import ? this.dst : this.src;
                String ltf = this.make_tempfile_f(fs_tab.tree_path + fn);
                String ztf = this.make_tempfile_z((this.pfx + fn).replace(File.separatorChar, '/'));
                Server.tx = new Server.Text("Differences");
                Server.do_diff(ltf, ztf);
                JScrollPane sp = new JScrollPane(Server.tx);
                sp.setPreferredSize(new Dimension(800, 600));
                sp.setMaximumSize(new Dimension(1000, 750));
                sp.setOpaque(true);
                JFrame frame = new JFrame("Diff for '" + fn + "'.");
                frame.setDefaultCloseOperation(2);
                frame.setContentPane(sp);
                frame.pack();
                frame.setVisible(true);
            }
            catch (Exception ex) {
                GUI.logger.log_stacktrace(ex);
            }
        } else if (name.equals("cancel")) {
            this.jf.setVisible(false);
            this.jf.dispose();
        } else {
            System.out.println("button '" + name + "' needs to be implemented.");
        }
    }

    private boolean any_left() {
        for (import_entry ie : this.l) {
            if (ie.operation.length() != 0) continue;
            return false;
        }
        return true;
    }

    private JButton b(String n) {
        return (JButton)this.dialog_items.get(n);
    }

    private void update_buttons() {
        this.b("change-Default").setEnabled(true);
        this.b("remove-Default").setEnabled(false);
        boolean cd = false;
        boolean rd = false;
        boolean cf = false;
        boolean rf = false;
        boolean diff = false;
        boolean details = false;
        if (this.jt.getSelectedRowCount() == 1) {
            details = true;
            import_entry ie = (import_entry)this.l.get(this.jt.getSelectedRow());
            String t = ie.get_latest_type();
            String f = ie.get_latest_full();
            String dr = "--------------------";
            String fr = "--------------------";
            if (t.equals("d")) {
                cd = true;
                String r = (String)this.rulesets.directory_rules.get(f);
                if (r != null) {
                    rd = true;
                    this.set_label("Directory", r);
                }
            } else {
                diff = true;
                cf = true;
                String r = (String)this.rulesets.directory_rules.get(f);
                if (r != null) {
                    rd = true;
                    this.set_label("Directory", r);
                }
            }
        }
        this.b("change-Directory").setEnabled(cd);
        this.b("remove-Directory").setEnabled(rd);
        this.b("change-File").setEnabled(cf);
        this.b("remove-File").setEnabled(rf);
        boolean any_selected = this.jt.getSelectedRowCount() > 0;
        this.b("ignore").setEnabled(any_selected);
        this.b("import").setEnabled(any_selected);
        this.b("delete").setEnabled(any_selected);
        this.b("rename").setEnabled(any_selected);
        this.b("file diff").setEnabled(diff);
        this.b("details").setEnabled(details);
        if (this.operation_changed) {
            this.b("ok").setEnabled(this.any_left());
            this.operation_changed = false;
        }
        this.b("cancel").setEnabled(true);
    }

    private static class row_sorter
    implements Comparator {
        private row_sorter() {
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        public int compare(Object oa, Object ob) {
            import_entry iea = (import_entry)oa;
            import_entry ieb = (import_entry)ob;
            int i = 0;
            int j = columnNames.length;
            int res = 0;
            block11: while (i < j && res == 0) {
                switch (sort_order[i++]) {
                    case 0: {
                        res = iea.compare_operation(ieb);
                        continue block11;
                    }
                    case 1: {
                        res = iea.compare_operation_src(ieb);
                        continue block11;
                    }
                    case 2: {
                        res = iea.compare_full(ieb);
                        continue block11;
                    }
                    case 3: {
                        res = iea.compare_type(ieb);
                        continue block11;
                    }
                    case 4: {
                        res = iea.compare_file(ieb);
                        continue block11;
                    }
                    case 5: {
                        res = iea.compare_extn(ieb);
                        continue block11;
                    }
                    case 6: {
                        res = iea.compare_time(ieb);
                        continue block11;
                    }
                    case 7: {
                        res = iea.compare_size(ieb);
                        continue block11;
                    }
                    case 8: {
                        res = iea.compare_state(ieb);
                        continue block11;
                    }
                }
                res = 0;
            }
            return res;
        }
    }
}

