/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.io.File;
import javax.swing.JOptionPane;
import net.os10000.bldsys.app_dsync.Certificate;
import net.os10000.bldsys.app_dsync.GUI;
import net.os10000.bldsys.app_dsync.Half;
import net.os10000.bldsys.app_dsync.Local_Tab;
import net.os10000.bldsys.app_dsync.Tab;

public class Local_Half
extends Half {
    private static final String pp = "net.os10000.bldsys.app_dsync.Local.";

    public Local_Half() {
        super("local");
    }

    @Override
    public void add() {
        try {
            Certificate crt = Certificate.make_Certificate(GUI.make_local_fn(GUI.local_context + ".crt"));
            String context_name = crt.context_name;
            boolean is_local = context_name.equals(GUI.local_context);
            String tree_name = this.make_name("tree", "");
            if (tree_name != null) {
                String tree_path = new File(System.getProperty("user.dir")).getAbsolutePath();
                String import_file = tree_path + File.separator + "to-" + context_name + "_" + context_name + ".snc";
                String export_file = tree_path + File.separator + "from-" + context_name + ".snc";
                tree_path = GUI.do_dir(tree_path);
                if (!is_local) {
                    import_file = JOptionPane.showInputDialog("Please enter the default import file", (Object)import_file);
                }
                export_file = JOptionPane.showInputDialog("Please enter the default export file", (Object)export_file);
                String short_remote = context_name.replaceAll("^([^_]+)(_.*)*$", "$1");
                String tab_name = this.make_name("tab", tree_name + "@" + short_remote);
                if (tab_name != null) {
                    String msg = "tab=" + tab_name + ", context=" + context_name + ", tree=" + tree_name + ", path=" + tree_path + (is_local ? "" : ", import=" + import_file) + ", export=" + export_file;
                    Local_Tab t = Local_Tab.make(tab_name, context_name, tree_name, tree_path, import_file, export_file, "");
                    Tab.write((Tab)t, GUI.make_local_fn(tab_name + "_" + GUI.local_context + ".tab"));
                    this.tp_entries.add(tab_name, t);
                    GUI.contexts.put(context_name, crt);
                    GUI.tabs.put(tab_name, t);
                    GUI.write_locations();
                    GUI.frame.setVisible(false);
                    GUI.frame.pack();
                    GUI.frame.setVisible(true);
                    GUI.remote.set_add_button();
                }
            }
        }
        catch (Exception e) {
            GUI.logger.log_stacktrace(e);
        }
    }
}

