/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.os10000.bldsys.app_dsync.Certificate;
import net.os10000.bldsys.app_dsync.Local_Half;
import net.os10000.bldsys.app_dsync.Local_Tab;
import net.os10000.bldsys.app_dsync.PrvKey;
import net.os10000.bldsys.app_dsync.PrvKeyFrame;
import net.os10000.bldsys.app_dsync.PubKeyFrame;
import net.os10000.bldsys.app_dsync.Remote_Half;
import net.os10000.bldsys.app_dsync.Remote_Tab;
import net.os10000.bldsys.app_dsync.Tab;
import net.os10000.bldsys.lib_logger.Logger;
import net.os10000.bldsys.lib_logwindow.Logwindow;
import net.os10000.bldsys.lib_properties.Properties;

public class GUI {
    private static Class cls = GUI.class;
    private static String dsync_dir = null;
    public static Local_Half local = null;
    public static Remote_Half remote = null;
    public static String local_context = null;
    public static JFrame frame = null;
    public static Map contexts = null;
    public static Map tabs = null;
    public static PrvKey private_key = null;
    public static Logger logger = null;

    private static void init_dir() {
        String default_dir = System.getProperty("user.dir") + File.separator + "app_dsync.dir";
        if (default_dir.equals(dsync_dir = Properties.get(cls, "dsync_dir", default_dir))) {
            try {
                new File(default_dir).mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void init_context() {
        local_context = Properties.get(cls, "local_context", "default");
    }

    public static String make_local_fn(String fn) {
        return dsync_dir + File.separator + fn;
    }

    private static void init_crypto() {
        String private_fn = GUI.make_local_fn(local_context + ".key");
        try {
            private_key = Certificate.read_private(private_fn);
        }
        catch (Exception e) {
            String msg = "Please provide a globally unique name for this system (os_work_os10000_net).";
            boolean done = false;
            while (!done) {
                local_context = JOptionPane.showInputDialog(msg);
                done = Certificate.check_name(local_context);
                if (done) continue;
                logger.logln("Error: The name must conform to '^[A-Za-z0-9@]+(_[A-Za-z0-9@]+)*$'.");
            }
            Properties.set(cls, "local_context", local_context);
            try {
                KeyPair kp = KeyPairGenerator.getInstance("RSA").genKeyPair();
                private_key = PrvKeyFrame.make_new_key(kp.getPrivate());
                private_fn = GUI.make_local_fn(local_context + ".key");
                Certificate.write_private(private_key, private_fn);
                Certificate crt = Certificate.make_Certificate(local_context, private_key, PubKeyFrame.make_new_key(kp.getPublic()));
                String public_fn = GUI.make_local_fn(local_context + ".crt");
                crt.write_to_stream(new FileOutputStream(public_fn));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void init_locations() {
        tabs = new HashMap();
        contexts = new HashMap();
        String locations_list = Properties.get(cls, "locations", "");
        if (locations_list.length() > 0) {
            for (String loc : locations_list.split(" ")) {
                if (loc.length() <= 0) continue;
                int sep = loc.indexOf("_");
                String tab_name = loc.substring(0, sep);
                String context_name = loc.substring(sep + 1);
                try {
                    String crt_fn = GUI.make_local_fn(context_name + ".crt");
                    Certificate crt = Certificate.make_Certificate(crt_fn);
                    contexts.put(context_name, crt);
                    String tab_fn = GUI.make_local_fn(loc + ".tab");
                    System.out.println("tab_fn=" + tab_fn);
                    FileInputStream is = new FileInputStream(tab_fn);
                    Tab t = Local_Tab.read(is);
                    if (context_name.equals(local_context)) {
                        GUI.local.tp_entries.add(tab_name, t);
                    } else {
                        GUI.remote.tp_entries.add(tab_name, t);
                    }
                    tabs.put(tab_name, t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        remote.set_add_button();
    }

    private static void init_peers() {
        for (Tab t : tabs.values()) {
            t.clear_peer();
        }
        for (Tab t : tabs.values()) {
            if (t.is_local) continue;
            Remote_Tab r = (Remote_Tab)t;
            Local_Tab l = (Local_Tab)tabs.get(r.associated_peer);
            r.add_peer(r.associated_peer);
            l.add_peer(r.tab_name);
        }
    }

    public static void write_locations() {
        String locations_list = "";
        String sep = "";
        for (Tab t : tabs.values()) {
            locations_list = locations_list + sep + t.tab_name + "_" + t.context_name;
            sep = " ";
        }
        Properties.set(cls, "locations", locations_list);
    }

    private static String do_either(String p, boolean is_dir) {
        JFileChooser jfc = new JFileChooser(p);
        if (is_dir) {
            jfc.setFileSelectionMode(1);
        }
        boolean approved = jfc.showOpenDialog(null) == 0;
        String res = approved ? jfc.getSelectedFile().getPath() : p;
        return res;
    }

    public static String do_dir(String p) {
        return GUI.do_either(p, true);
    }

    public static String do_file(String p) {
        return GUI.do_either(p, false);
    }

    public static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JPanel tp = new JPanel();
        tp.setOpaque(true);
        JPanel p_upper = new JPanel();
        local = new Local_Half();
        p_upper.add(local);
        p_upper.add(new JSeparator(1));
        remote = new Remote_Half();
        p_upper.add(remote);
        JPanel p_lower = new JPanel();
        p_lower.setPreferredSize(new Dimension(610, 200));
        Logwindow.tp = p_lower;
        logger = new Logger("Dsync");
        tp.setLayout(new BoxLayout(tp, 1));
        tp.add(p_upper);
        tp.add(new JSeparator(0));
        tp.add(p_lower);
        Dimension fill = new Dimension(5, 5);
        tp.add(new Box.Filler(fill, fill, fill));
        GUI.init_dir();
        GUI.init_context();
        GUI.init_crypto();
        GUI.init_locations();
        GUI.init_peers();
        frame = new JFrame("DSync");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(tp);
        frame.pack();
        frame.setVisible(true);
    }

    public static void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GUI.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            if (logger == null) {
                logger = new Logger(null);
            }
            logger.log_stacktrace(e);
        }
    }
}

