/*
 * Decompiled with CFR 0.152.
 */
package net.os10000.bldsys.app_dsync;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import net.os10000.bldsys.app_dsync.ObjectStream;
import net.os10000.bldsys.app_dsync.PrvKey;
import net.os10000.bldsys.app_dsync.PrvKeyFrame;
import net.os10000.bldsys.app_dsync.PubKey;
import net.os10000.bldsys.app_dsync.PubKeyFrame;

public class Certificate {
    public static final String name_syntax = "^[A-Za-z0-9@]+(_[A-Za-z0-9@]+)*$";
    public String context_name;
    public PubKey public_key;
    public byte[] signature;
    public Signature sig;

    public static boolean check_name(String name) {
        return name.matches(name_syntax);
    }

    public static Signature make_sig() {
        Signature res = null;
        try {
            res = Signature.getInstance("SHA1withRSA");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private Certificate(String context_name, PubKey public_key, byte[] signature) {
        this.context_name = context_name;
        this.public_key = public_key;
        this.signature = signature;
        this.sig = Certificate.make_sig();
    }

    private static byte[] byteify(String t_name, PubKey t_public_key) {
        String pk = t_public_key.printable();
        return (t_name + ":" + pk).getBytes();
    }

    public void write_to_stream(OutputStream os) throws IOException {
        ObjectStream obs = new ObjectStream(os);
        obs.writeObject(this.context_name);
        obs.writeObject(this.public_key);
        obs.writeObject(this.signature);
        obs.close();
    }

    public static void write_private(PrvKey t_private_key, String fn) throws IOException {
        FileOutputStream os = new FileOutputStream(fn);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(t_private_key);
        oos.close();
    }

    public static PrvKey read_private(String fn) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(fn);
        ObjectInputStream ois = new ObjectInputStream(is);
        PrvKey private_key = (PrvKey)ois.readObject();
        ois.close();
        return private_key;
    }

    public static Certificate make_Certificate(InputStream is) throws IOException, ClassNotFoundException, SignatureException {
        byte[] t_signature;
        PubKey t_public_key;
        ObjectInputStream ois = new ObjectInputStream(is);
        String t_name = (String)ois.readObject();
        Certificate res = new Certificate(t_name, t_public_key = (PubKey)ois.readObject(), t_signature = (byte[])ois.readObject());
        if (!res.verify_array(Certificate.byteify(t_name, t_public_key))) {
            throw new SignatureException("inconsistent Certificate '" + t_name + "'");
        }
        return res;
    }

    public static Certificate make_Certificate(String fn) throws IOException, ClassNotFoundException, SignatureException {
        FileInputStream is = new FileInputStream(fn);
        Certificate res = Certificate.make_Certificate(is);
        ((InputStream)is).close();
        return res;
    }

    public static Certificate make_Certificate(String t_name, PrvKey t_private_key, PubKey t_public_key) {
        Signature s = Certificate.make_sig();
        byte[] t_signature = null;
        try {
            s.initSign(PrvKeyFrame.k(t_private_key));
            s.update(Certificate.byteify(t_name, t_public_key));
            t_signature = s.sign();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Certificate(t_name, t_public_key, t_signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify_stream(InputStream is, byte[] sigbytes) {
        boolean res = false;
        Signature signature = this.sig;
        synchronized (signature) {
            try {
                this.sig.initVerify(PubKeyFrame.k(this.public_key));
                byte[] buf = new byte[512];
                int bytes = is.read(buf, 0, buf.length);
                while (bytes > 0) {
                    this.sig.update(buf, 0, bytes);
                    bytes = is.read(buf, 0, buf.length);
                }
                res = this.sig.verify(sigbytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify_array(byte[] data) {
        boolean res = false;
        Signature signature = this.sig;
        synchronized (signature) {
            try {
                this.sig.initVerify(PubKeyFrame.k(this.public_key));
                this.sig.update(data);
                res = this.sig.verify(this.signature);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }
}

